#include <stdio.h>

#include "debugdecode.h"


static int zoom_offset = 0;
static bool use_offset = false;

void DebugDecoder::processKey(WPARAM key)
{
	switch(key)
   {
   	case VK_PRIOR:
      	if (zoom_offset < 2250)
         	zoom_offset += 50;
         break;
      case VK_NEXT:
      	if (zoom_offset > 50)
         	zoom_offset -= 50;
         else
         	zoom_offset = 0;
         break;
      case 'Z':
      	_zoom_mode = !_zoom_mode;
         break;
      case 'O':
      	use_offset = !use_offset;
         break;
   }
}

const char* DebugDecoder::getHelp(void) const
{
	return("  Z: Commutar a pantalla conpleta\n"
   		 "  PG UP/DOWN: Ajustar desplazamiento de pantalla\n"
          "  O: Use offset\n");
}

void DebugDecoder::decodeFrame(unsigned char *membase, int offset,
  bool invert_polarity)
{
	int v;
	int lp_filter;
	RGBTRIPLE pixels[800];

	if (use_offset)
   		membase += offset;

	unsigned char *start = membase;

	lockDisplay();

	for (int y=0; y < 300; y++)
	{
		unsigned int fss=0;
   	lp_filter = 0;

      int xx=0;
   	for (int x = 0; x < 2268 && xx < 800; x++)
		{
         lp_filter += membase[x];
  	      if (x >= 8)
     	   	lp_filter -= membase[x-8];

         if ((x % 4) == 0 || _zoom_mode)
         {
           	v = lp_filter / 3;

            if (_zoom_mode)
            {
            	if (x < zoom_offset)
            		continue;
               v = membase[x];
            }

  	         v += 60;

            if (invert_polarity)
            {
   	      	v = 255 - v;
            }

            if (v > 255)
            	v = 255;
            else if (v < 0)
            	v = 0;

				if ((y & 1) && (x / 4 == _hsync / 4))
            {
					pixels[xx].rgbtRed = 0;
               pixels[xx].rgbtGreen = 200;
               pixels[xx].rgbtBlue = 0;
            }
            else
	           	pixels[xx].rgbtRed = pixels[xx].rgbtGreen = pixels[xx].rgbtBlue = v;
            xx++;
      	}
      }

      drawPixels(0, y, pixels, xx);

      membase += 2268;
	}

	unlockDisplay();

   membase = start + 100 * 2268;
   if (_zoom_mode)
   	membase += zoom_offset;
	for (int x = 0; x < 800; x++)
   {
      int y = *membase;
      membase += (_zoom_mode)?1:4;
      putPixel(x, y, 255, 255, 0);
   }

   char buf[500];
   POINT pos;
   GetCursorPos(&pos);
   extern HWND	hWnd;
   ScreenToClient(hWnd, &pos);

   sprintf(buf, "MouseX %ld MouseY %ld",
     pos.x, pos.y);
   drawText(30, 250, buf, RGB(0, 0, 200));
}
